UNIT mTAnwendung;

interface

//--------------------  ggf Uses-Liste anpassen !  --------------------
uses mTReflexionsKugel, mSum, mUhr, mTKugel, mTReflexionsbox, mTSpielfeld;

type
  TAnwendung = class

  private //Attribute
    derBildschirm : Bildschirm;
    dieMaus : Maus;
    meinStift : Stift;
    dritteKugel : TReflexionsKugel;
    ersteKugel : TReflexionsKugel;
    vierteKugel : TReflexionsKugel;
    zweiteKugel : TReflexionsKugel;
    Reflexionsbox1 : TReflexionsbox;
    Reflexionsbox2 : TReflexionsbox;
    erstesSpielfeld : TSpielfeld;
    zweitesSpielfeld : TSpielfeld;
    meineUhr : Uhr;

     //Objektbeziehungen:
        // hatTReflexionsbox1, // hatTReflexionsbox2 : TReflexionsbox;
        // hatTReflexionsbox1, // hatTReflexionsbox2 : TReflexionsbox;
        // hatTSpielfeld1, // hatTSpielfeld2 : TSpielfeld;
        // hatTSpielfeld () of TSpielfeld;
        // hatTReflexionsKugel1, // hatTReflexionsKugel2, // hatTReflexionsKugel3, // hatTReflexionsKugel4 : TReflexionsKugel;

  public //Methoden
    constructor init; virtual;
    procedure laufeab; virtual;
    destructor gibFrei; virtual;

   end;

implementation

//+---------------------------------------------------------------------
//|         TAnwendung: Methodendefinition 
//+---------------------------------------------------------------------

//-------- init (public) -----------------------------------------------
constructor TAnwendung.init;
begin
  // Initialisierung
    derBildschirm := Bildschirm.init;
    dieMaus       := Maus.init;
    meinStift     := Stift.init;
    meineUhr      := Uhr.init;
  // Kugeln erzeugen
    ersteKugel    := TReflexionsKugel.init;
    zweiteKugel   := TReflexionsKugel.init;
    dritteKugel   := TReflexionsKugel.init;
    vierteKugel   := TReflexionsKugel.init;
  //Spielfelder erzeugen
     erstesSpielfeld := TSpielfeld.init(400, 300);
     zweitesSpielfeld := TSpielfeld.init(350, 400);
  //Reflexionsboxen erzeugen
     Reflexionsbox1 := TReflexionsbox.init(150, 150);
     Reflexionsbox2 := TReflexionsbox.init(75, 100);
     Reflexionsbox1.setzePosition(200, 200);
     Reflexionsbox2.setzePosition(750, 250);


  //Spielfelder zeichnen
     erstesSpielfeld.setzePosition(100, 100);
     zweitesSpielfeld.setzePosition(600, 100);

     ersteKugel.lerneSpielfeldkennen(erstesSpielfeld);
     ersteKugel.lerneReflexionsboxkennen(Reflexionsbox1);
     ersteKugel.setzePosition(erstesSpielfeld.GibXPos+12, erstesSpielfeld.GibYPos+erstesSpielfeld.GibHoehe/3.5);
     ersteKugel.SetzexGeschwindigkeit(2);
     ersteKugel.SetzeyGeschwindigkeit(1);

     zweiteKugel.lerneSpielfeldkennen(erstesspielfeld);
     zweiteKugel.lerneReflexionsboxkennen(Reflexionsbox1);
     zweiteKugel.setzePosition(erstesSpielfeld.GibXPos+erstesSpielfeld.GibBreite-12, erstesSpielfeld.GibYPos+erstesSpielfeld.GibHoehe/1.5);
     zweiteKugel.SetzexGeschwindigkeit(-2);
     zweiteKugel.SetzeyGeschwindigkeit(-0.5);

     dritteKugel.lerneSpielfeldkennen(zweitesSpielfeld);
     dritteKugel.lerneReflexionsboxkennen(Reflexionsbox2);
     dritteKugel.setzePosition(zweitesSpielfeld.GibXPos+12, zweitesSpielfeld.GibYPos+zweitesSpielfeld.GibHoehe/3.5);
     dritteKugel.SetzexGeschwindigkeit(1.5);
     dritteKugel.SetzeyGeschwindigkeit(1);

     vierteKugel.lerneSpielfeldkennen(zweitesSpielfeld);
     vierteKugel.lerneReflexionsboxkennen(Reflexionsbox2);
     vierteKugel.setzePosition(zweitesSpielfeld.GibXPos+12, zweitesSpielfeld.GibYPos+zweitesSpielfeld.GibHoehe/3.5);
     vierteKugel.SetzexGeschwindigkeit(2);
     vierteKugel.SetzeyGeschwindigkeit(-0.3);
end;

//-------- laufeab (public) --------------------------------------------
procedure TAnwendung.laufeab;
begin
  repeat
     ersteKugel.bewege;
     zweiteKugel.bewege;
     dritteKugel.bewege;
     vierteKugel.bewege;
     meineUhr.warte(1);
  until dieMaus.istGedrueckt;
  
end;

//-------- gibFrei (public) --------------------------------------------
destructor TAnwendung.gibFrei;
begin
  // Aufrumen
  dieMaus.gibFrei;
  derBildschirm.gibFrei;
  ersteKugel.gibfrei;
  zweiteKugel.gibfrei;
  dritteKugel.gibfrei;
  vierteKugel.gibfrei;
  erstesSpielfeld.gibfrei;
  zweitesSpielfeld.gibfrei;
  Reflexionsbox1.gibFrei;
  Reflexionsbox2.gibFrei;
end;

end.
