UNIT mTKugel;

interface

//--------------------  ggf Uses-Liste anpassen !  --------------------
uses mTReflexionsbox, mTSpielfeld, mSuM;

type
  TKugel = class

  private //Attribute
    meinStift : Stift;
    kenntReflexionsbox : tReflexionsbox;
    kenntSpielfeld : TSpielfeld;
    xPos : Zahl;
    yPos : Zahl;
    zxGeschwindigkeit : Zahl;
    zyGeschwindigkeit : Zahl;

     //Objektbeziehungen:
        // kenntTSpielfeld : TSpielfeld;
        // kenntTReflexionsbox : TReflexionsbox;

  public //Methoden
    constructor init; virtual;
    procedure bewege; virtual;
    procedure lerneReflexionsboxkennen (pKenntReflexionsbox: tReflexionsbox); virtual;
    procedure lerneSpielfeldkennen (pKenntSpielfeld: TSpielfeld); virtual;
    procedure loesche; virtual;
    procedure setzePosition (pXPos: Zahl; pYPos: Zahl); virtual;
    procedure SetzexGeschwindigkeit (pZxGeschwindigkeit: Zahl); virtual;
    procedure SetzeyGeschwindigkeit (pZyGeschwindigkeit: Zahl); virtual;
    procedure zeichne; virtual;
    destructor gibfrei; virtual;

   end;

implementation

//+---------------------------------------------------------------------
//|         TKugel: Methodendefinition 
//+---------------------------------------------------------------------

//-------- init (public) -----------------------------------------------
constructor TKugel.init;
begin
  meinStift :=Stift.init ;
  meinStift.wechsle;
  xPos := 0;
  yPos := 0;
  self.zeichne
end;

//-------- bewege (public) ---------------------------------------------
procedure TKugel.bewege;
begin

  //Kugel an alter Stelle lschen
  self.loesche;

  //Kugle an neue Stelle bewegen
  xPos := xPos + zxGeschwindigkeit;
  yPos := yPos + zyGeschwindigkeit;

  //Kugel neu zeichnen
  self.zeichne;

  //Reflexion an den Spielfeldrndern
  if self.xPos - 11 <= kenntSpielfeld.GibXPos
     then self.SetzexGeschwindigkeit(self.zxGeschwindigkeit*(-1));
  if self.xPos + 11 >= kenntSpielfeld.GibXPos + kenntSpielfeld.GibBreite
     then self.SetzexGeschwindigkeit(self.zxGeschwindigkeit*(-1));

  if self.yPos - 11 <= kenntSpielfeld.Gibypos
     then self.SetzeyGeschwindigkeit(self.zyGeschwindigkeit*(-1));

  if self.yPos + 11 >= kenntSpielfeld.Gibypos + kenntSpielfeld.gibHoehe
     then self.SetzeyGeschwindigkeit(self.zyGeschwindigkeit*(-1));


  //Reflexionsbox
   //linker Rand
  if (self.zxGeschwindigkeit > 0) and
     (self.xPos > kenntReflexionsbox.gibxPos-11)  and
     (self.xPos < kenntReflexionsbox.gibxPos) and
     (self.yPos < kenntReflexionsbox.gibyPos + kenntReflexionsbox.gibHoehe+5) and
     (self.yPos > kenntReflexionsbox.gibyPos-5)
  then self.ZxGeschwindigkeit := -self.ZxGeschwindigkeit;


   //rechter Rand
  if (self.zxGeschwindigkeit < 0) and
     (self.xPos < kenntReflexionsbox.gibxPos + kenntReflexionsbox.gibBreite+11) and
     (self.xPos > kenntReflexionsbox.gibxPos + kenntReflexionsbox.gibBreite) and
     (self.yPos < kenntReflexionsbox.gibyPos + kenntReflexionsbox.gibHoehe+5) and
     (self.yPos > kenntReflexionsbox.gibyPos-5)
  then self.zxGeschwindigkeit := -self.ZxGeschwindigkeit;

   //oberer Rand
  if (self.zYGeschwindigkeit > 0) and
     (self.yPos > kenntReflexionsbox.gibyPos-11)  and
     (self.yPos < kenntReflexionsbox.gibyPos) and
     (self.xPos < kenntReflexionsbox.gibxPos + kenntReflexionsbox.gibBreite+5) and
     (self.xPos > kenntReflexionsbox.gibxPos-5)
  then self.ZyGeschwindigkeit := -self.ZyGeschwindigkeit;

    //unterer Rand
  if (self.zYGeschwindigkeit < 0) and
     (self.yPos < kenntReflexionsbox.gibyPos + kenntReflexionsbox.gibHoehe+11) and
     (self.yPos > kenntReflexionsbox.gibyPos + kenntReflexionsbox.gibHoehe) and
     (self.xPos < kenntReflexionsbox.gibxPos + kenntReflexionsbox.gibBreite+5) and
     (self.xPos > kenntReflexionsbox.gibxPos-5)
  then self.zyGeschwindigkeit := -self.ZyGeschwindigkeit;


end;

//-------- lerneReflexionsboxkennen (public) ---------------------------
procedure TKugel.lerneReflexionsboxkennen (pKenntReflexionsbox: tReflexionsbox);
begin
  kenntReflexionsbox := pKenntReflexionsbox
end;

//-------- lerneSpielfeldkennen (public) -------------------------------
procedure TKugel.lerneSpielfeldkennen (pKenntSpielfeld: TSpielfeld);
begin
  kenntSpielfeld := pKenntSpielfeld;
end;

//-------- loesche (public) --------------------------------------------
procedure TKugel.loesche;
begin
  self.zeichne
end;

//-------- setzePosition (public) --------------------------------------
procedure TKugel.setzePosition (pXPos: Zahl; pYPos: Zahl);
begin
  self.loesche;
  xPos := pXPos;
  yPos := pYPos;
  self.zeichne
end;

//-------- SetzexGeschwindigkeit (public) ------------------------------
procedure TKugel.SetzexGeschwindigkeit (pZxGeschwindigkeit: Zahl);
begin
   zxGeschwindigkeit := pZxGeschwindigkeit
end;

//-------- SetzeyGeschwindigkeit (public) ------------------------------
procedure TKugel.SetzeyGeschwindigkeit (pZyGeschwindigkeit: Zahl);
begin
   zyGeschwindigkeit := pZyGeschwindigkeit
end;

//-------- zeichne (public) --------------------------------------------
procedure TKugel.zeichne;
begin
  meinStift.bewegeBis(xPos,yPos);
  meinStift.zeichneKreis(10)
end;

//-------- gibfrei (public) --------------------------------------------
destructor TKugel.gibfrei;
begin
  meinStift.gibfrei;
end;

end.
