program Reflexionsbox;

uses
  mSum,
  mUhr,
  mTSpielfeld in 'mTSpielfeld.pas',
  mTReflexionsbox in 'mTReflexionsbox.pas',
  mTKugel in 'mTKugel.pas';

var
  derBildschirm    : Bildschirm;
  dieMaus          : Maus;
  meinStift        : Stift;
  meineUhr         : Uhr;
  ersteKugel       : TKugel;
  zweiteKugel      : TKugel;
  dritteKugel      : TKugel;
  vierteKugel      : TKugel;
  erstesSpielfeld  : TSpielfeld;
  zweitesSpielfeld : TSpielfeld;
  Reflexionsbox1   : TReflexionsbox;
  Reflexionsbox2   : TReflexionsbox;
begin

  // Initialisierung
  derBildschirm := Bildschirm.init;
  dieMaus       := Maus.init;
  meinStift     := Stift.init;
  meineUhr      := Uhr.init;

  // Kugeln erzeugen
  ersteKugel    := TKugel.init;
  zweiteKugel   := TKugel.init;
  dritteKugel   := TKugel.init;
  vierteKugel   := TKugel.init;

  //Spielfelder erzeugen
  erstesSpielfeld := TSpielfeld.init(400, 300);
  zweitesSpielfeld := TSpielfeld.init(350, 400);
  erstesSpielfeld.setzePosition(100, 100);
  zweitesSpielfeld.setzePosition(600, 100);

  //Reflexionsboxen erzeugen
  Reflexionsbox1 := TReflexionsbox.init(150, 150);
  Reflexionsbox2 := TReflexionsbox.init(75, 100);
  Reflexionsbox1.setzePosition(200, 200);
  Reflexionsbox2.setzePosition(750, 250);

  // Anfangswerte der Kugeln festsetzen
     ersteKugel.lerneSpielfeldkennen(erstesSpielfeld);
     ersteKugel.lerneReflexionsboxkennen(Reflexionsbox1);
     ersteKugel.setzePosition(erstesSpielfeld.GibXPos+12, erstesSpielfeld.GibYPos+erstesSpielfeld.GibHoehe/3.5);
     ersteKugel.SetzexGeschwindigkeit(2);
     ersteKugel.SetzeyGeschwindigkeit(1);

     zweiteKugel.lerneSpielfeldkennen(erstesspielfeld);
     zweiteKugel.lerneReflexionsboxkennen(Reflexionsbox1);
     zweiteKugel.setzePosition(erstesSpielfeld.GibXPos+erstesSpielfeld.GibBreite-12, erstesSpielfeld.GibYPos+erstesSpielfeld.GibHoehe/1.5);
     zweiteKugel.SetzexGeschwindigkeit(-2);
     zweiteKugel.SetzeyGeschwindigkeit(-0.5);

     dritteKugel.lerneSpielfeldkennen(zweitesSpielfeld);
     dritteKugel.lerneReflexionsboxkennen(Reflexionsbox2);
     dritteKugel.setzePosition(zweitesSpielfeld.GibXPos+12, zweitesSpielfeld.GibYPos+zweitesSpielfeld.GibHoehe/3.5);
     dritteKugel.SetzexGeschwindigkeit(1.5);
     dritteKugel.SetzeyGeschwindigkeit(1);

     vierteKugel.lerneSpielfeldkennen(zweitesSpielfeld);
     vierteKugel.lerneReflexionsboxkennen(Reflexionsbox2);
     vierteKugel.setzePosition(zweitesSpielfeld.GibXPos+12, zweitesSpielfeld.GibYPos+zweitesSpielfeld.GibHoehe/3.5);
     vierteKugel.SetzexGeschwindigkeit(2);
     vierteKugel.SetzeyGeschwindigkeit(-0.3);

  // eigentlicher Ablauf des Spieles
  repeat
     ersteKugel.bewege;
     zweiteKugel.bewege;
     dritteKugel.bewege;
     vierteKugel.bewege;

     meineUhr.warte(1);
  until dieMaus.istGedrueckt;

    // Aufrumen
  dieMaus.gibFrei;
  derBildschirm.gibFrei;
  ersteKugel.gibfrei;
  zweiteKugel.gibfrei;
  dritteKugel.gibfrei;
  vierteKugel.gibfrei;
  erstesSpielfeld.gibfrei;
  zweitesSpielfeld.gibfrei;
  Reflexionsbox1.gibFrei;
  Reflexionsbox2.gibFrei;
end.
