program Fangbox;

uses
  mSum,
  mUhr,
  mTSpielfeld in 'mTSpielfeld.pas',
  mTFangbox in 'mTFangbox.pas',
  mTKugel in 'mTKugel.pas';

var
  derBildschirm    : Bildschirm;
  dieMaus          : Maus;
  meinStift        : Stift;
  meineUhr         : Uhr;
  ersteKugel       : TKugel;
  zweiteKugel      : TKugel;
  dritteKugel      : TKugel;
  vierteKugel      : TKugel;
  erstesSpielfeld  : TSpielfeld;
  zweitesSpielfeld : TSpielfeld;
  Fangbox1   : TFangbox;
  Fangbox2   : TFangbox;
begin

  // Initialisierung
  derBildschirm := Bildschirm.init;
  dieMaus       := Maus.init;
  meinStift     := Stift.init;
  meineUhr      := Uhr.init;

  // Kugeln erzeugen
  ersteKugel    := TKugel.init;
  zweiteKugel   := TKugel.init;
  dritteKugel   := TKugel.init;
  vierteKugel   := TKugel.init;

  //Spielfelder erzeugen
  erstesSpielfeld := TSpielfeld.init(400, 300);
  zweitesSpielfeld := TSpielfeld.init(350, 400);
  erstesSpielfeld.setzePosition(100, 100);
  zweitesSpielfeld.setzePosition(600, 100);

  //Fangboxen erzeugen
  Fangbox1 := TFangbox.init(70, 50);
  Fangbox2 := TFangbox.init(60, 70);
  Fangbox1.setzePosition(200, 200);
  Fangbox2.setzePosition(750, 250);

  // Anfangswerte der Kugeln festsetzen
     ersteKugel.lerneSpielfeldkennen(erstesSpielfeld);
     ersteKugel.lerneFangboxkennen(Fangbox1);
     ersteKugel.setzePosition(erstesSpielfeld.GibXPos+12, erstesSpielfeld.GibYPos+erstesSpielfeld.GibHoehe/3.5);
     ersteKugel.SetzexGeschwindigkeit(2.5);
     ersteKugel.SetzeyGeschwindigkeit(1.5);

     zweiteKugel.lerneSpielfeldkennen(erstesspielfeld);
     zweiteKugel.lerneFangboxkennen(Fangbox1);
     zweiteKugel.setzePosition(erstesSpielfeld.GibXPos+erstesSpielfeld.GibBreite-12, erstesSpielfeld.GibYPos+erstesSpielfeld.GibHoehe/1.5);
     zweiteKugel.SetzexGeschwindigkeit(-2);
     zweiteKugel.SetzeyGeschwindigkeit(-1.5);

     dritteKugel.lerneSpielfeldkennen(zweitesSpielfeld);
     dritteKugel.lerneFangboxkennen(Fangbox2);
     dritteKugel.setzePosition(zweitesSpielfeld.GibXPos+12, zweitesSpielfeld.GibYPos+zweitesSpielfeld.GibHoehe/3.5);
     dritteKugel.SetzexGeschwindigkeit(1.5);
     dritteKugel.SetzeyGeschwindigkeit(1);

     vierteKugel.lerneSpielfeldkennen(zweitesSpielfeld);
     vierteKugel.lerneFangboxkennen(Fangbox2);
     vierteKugel.setzePosition(zweitesSpielfeld.GibXPos+12, zweitesSpielfeld.GibYPos+zweitesSpielfeld.GibHoehe/3.5);
     vierteKugel.SetzexGeschwindigkeit(2);
     vierteKugel.SetzeyGeschwindigkeit(-0.3);

  // eigentlicher Ablauf des Spieles
  repeat
     ersteKugel.bewege;
     zweiteKugel.bewege;
     dritteKugel.bewege;
     vierteKugel.bewege;

     meineUhr.warte(1);
  until dieMaus.istGedrueckt;

    // Aufrumen
  dieMaus.gibFrei;
  derBildschirm.gibFrei;
  ersteKugel.gibfrei;
  zweiteKugel.gibfrei;
  dritteKugel.gibfrei;
  vierteKugel.gibfrei;
  erstesSpielfeld.gibfrei;
  zweitesSpielfeld.gibfrei;
  Fangbox1.gibFrei;
  Fangbox2.gibFrei;
end.
