UNIT mTKugel;

interface

//--------------------  ggf Uses-Liste anpassen !  --------------------
uses mTSpielfeld, mSuM;

type
  TKugel = class

  private //Attribute
    meinStift : Stift;
    kenntSpielfeld : TSpielfeld;
    AktuelleGeschwindigkeit : Zahl;
    AkuelleXPos : Zahl;
    AkuelleYPos : Zahl;

     //Objektbeziehungen:
        // kenntTSpielfeld : TSpielfeld;
        // kenntTKugel () of TKugel;

  public //Methoden
    constructor init; virtual;
    procedure bewege; virtual;
    procedure lerneSpielfeldKennen (pKenntSpielfeld: TSpielfeld); virtual;
    procedure SetzeGeschwindigkeit (pAktuelleGeschwindigkeit: Zahl); virtual;
    procedure setzePosition (pXPos: Zahl; pYPos: Zahl); virtual;
    function GibGeschwindigkeit : Zahl; virtual;
    function GibXPos : Zahl; virtual;
    destructor gibFrei; virtual;

   end;

implementation

//+---------------------------------------------------------------------
//|         TKugel: Methodendefinition 
//+---------------------------------------------------------------------

//-------- init (public) -----------------------------------------------
constructor TKugel.init;
begin
  meinStift := Stift.init;
  AkuelleXPos := 0;
  AkuelleYPos := 0;
end;

//-------- bewege (public) ---------------------------------------------
procedure TKugel.bewege;
begin
     //Kugel an alter Stelle lschen
     meinStift.radiere;
     meinStift.bewegeBis(AkuelleXPos,AkuelleYPos);
     meinStift.zeichneKreis(10);

     //Kugel an neue Stelle bewegen
     AkuelleXPos := AkuelleXPos + AktuelleGeschwindigkeit;

     //Kugel neu zeichnen
     meinStift.normal;
     meinStift.bewegeBis(AkuelleXPos,AkuelleYPos);
     meinStift.zeichneKreis(10);

    if self.GibXPos + 12 > kenntSpielfeld.rechterRand then
       self.setzeGeschwindigkeit(-self.GibGeschwindigkeit);
    if self.GibXPos - 12 < kenntSpielfeld.linkerRand then
       self.setzeGeschwindigkeit(-self.GibGeschwindigkeit);

end;

//-------- lerneSpielfeldKennen (public) -------------------------------
procedure TKugel.lerneSpielfeldKennen (pKenntSpielfeld: TSpielfeld);
begin
  kenntSpielfeld := pKenntSpielfeld
end;

//-------- SetzeGeschwindigkeit (public) -------------------------------
procedure TKugel.SetzeGeschwindigkeit (pAktuelleGeschwindigkeit: Zahl);
begin
   AktuelleGeschwindigkeit := pAktuelleGeschwindigkeit
end;

//-------- setzePosition (public) --------------------------------------
procedure TKugel.setzePosition (pXPos: Zahl; pYPos: Zahl);
begin
   //Kugel an alter Stelle lschen
   meinStift.radiere;
   meinStift.bewegeBis(AkuelleXPos,AkuelleYPos);
   meinStift.zeichneKreis(10);

   //Gedchtnis benutzen !!  : Position merken
   AkuelleXPos := pXPos;
   AkuelleYPos := pYPos;

   //neu Zeichnen an neuer Position
   meinStift.normal;
   meinStift.bewegeBis(AkuelleXPos,AkuelleYPos);
   meinStift.zeichneKreis(10);
end;

//-------- GibGeschwindigkeit (public) ---------------------------------
function TKugel.GibGeschwindigkeit : Zahl;
begin
  result := AktuelleGeschwindigkeit
end;

//-------- GibXPos (public) --------------------------------------------
function TKugel.GibXPos : Zahl;
begin
  result := AkuelleXPos
end;

//-------- gibFrei (public) --------------------------------------------
destructor TKugel.gibFrei;
begin
  meinStift.gibFrei;
end;

end.
