UNIT mTKugel;

interface

//--------------------  ggf Uses-Liste anpassen !  --------------------
uses mSuM;

type
  TKugel = class

  private //Attribute
    meinStift : Stift;
    AktuelleGeschwindigkeit : Zahl;
    AkuelleXPos : Zahl;
    AkuelleYPos : Zahl;

  public //Methoden
    constructor init; virtual;
    procedure bewege; virtual;
    procedure SetzeGeschwindigkeit (pAktuelleGeschwindigkeit: Zahl); virtual;
    procedure setzePosition (pXPos: Zahl; pYPos: Zahl); virtual;
    function GibGeschwindigkeit : Zahl; virtual;
    function GibXPos : Zahl; virtual;
    destructor gibFrei; virtual;

   end;

implementation

//+---------------------------------------------------------------------
//|         TKugel: Methodendefinition 
//+---------------------------------------------------------------------

//-------- init (public) -----------------------------------------------
constructor TKugel.init;
begin
  meinStift := Stift.init;
  AkuelleXPos := 0;
  AkuelleYPos := 0;
end;

//-------- bewege (public) ---------------------------------------------
procedure TKugel.bewege;
begin
     //Kugel an alter Stelle lschen
     meinStift.radiere;
     meinStift.bewegeBis(AkuelleXPos,AkuelleYPos);
     meinStift.zeichneKreis(10);

     //Kugel an neue Stelle bewegen
     AkuelleXPos := AkuelleXPos + AktuelleGeschwindigkeit;

     //Kugel neu zeichnen
     meinStift.normal;
     meinStift.bewegeBis(AkuelleXPos,AkuelleYPos);
     meinStift.zeichneKreis(10);
end;

//-------- SetzeGeschwindigkeit (public) -------------------------------
procedure TKugel.SetzeGeschwindigkeit (pAktuelleGeschwindigkeit: Zahl);
begin
   AktuelleGeschwindigkeit := pAktuelleGeschwindigkeit
end;

//-------- setzePosition (public) --------------------------------------
procedure TKugel.setzePosition (pXPos: Zahl; pYPos: Zahl);
begin
   //Kugel an alter Stelle lschen
   meinStift.radiere;
   meinStift.bewegeBis(AkuelleXPos,AkuelleYPos);
   meinStift.zeichneKreis(10);

   //Gedchtnis benutzen !!  : Position merken
   AkuelleXPos := pXPos;
   AkuelleYPos := pYPos;

   //neu Zeichnen an neuer Position
   meinStift.normal;
   meinStift.bewegeBis(AkuelleXPos,AkuelleYPos);
   meinStift.zeichneKreis(10);
end;

//-------- GibGeschwindigkeit (public) ---------------------------------
function TKugel.GibGeschwindigkeit : Zahl;
begin
  result := AktuelleGeschwindigkeit
end;

//-------- GibXPos (public) --------------------------------------------
function TKugel.GibXPos : Zahl;
begin
  result := AkuelleXPos
end;

//-------- gibFrei (public) --------------------------------------------
destructor TKugel.gibFrei;
begin
  meinStift.gibFrei;
end;

end.
