UNIT mTKugel;

interface

//--------------------  ggf Uses-Liste anpassen !  --------------------
uses mSuM;

type
   TKugel = CLASS

     // weitere Attribute
     private
        meinStift : Stift;  // Hilfswerkzeug
        AkuelleXPos : Zahl;        // Gedchtnis
        AkuelleYPos : Zahl;        // Gedchtnis

     // weitere Methoden
     public
        constructor init; virtual;
        procedure bewege; virtual;
        procedure setzePosition (pXPos: Zahl; pYPos: Zahl); virtual;
        destructor gibFrei; virtual;

   end;

implementation

//+---------------------------------------------------------------------
//|         TKugel: Methodendefinition 
//+---------------------------------------------------------------------

//-------- init (public) -----------------------------------------------
constructor TKugel.init;
begin
  meinStift := Stift.init;
  AkuelleXPos := 0;
  AkuelleYPos := 0;
end;

//-------- bewege (public) ---------------------------------------------
procedure TKugel.bewege;
begin
     //Kugel an alter Stelle lschen
     meinStift.radiere;
     meinStift.bewegeBis(AkuelleXPos,AkuelleYPos);
     meinStift.zeichneKreis(10);

     //Kugel an neue Stelle bewegen
     AkuelleXPos := AkuelleXPos + 0.5;

     //Kugel neu zeichnen
     meinStift.normal;
     meinStift.bewegeBis(AkuelleXPos,AkuelleYPos);
     meinStift.zeichneKreis(10);
end;

//-------- setzePosition (public) --------------------------------------
procedure TKugel.setzePosition (pXPos: Zahl; pYPos: Zahl);
begin
   //Kugel an alter Stelle lschen
   meinStift.radiere;
   meinStift.bewegeBis(AkuelleXPos,AkuelleYPos);
   meinStift.zeichneKreis(10);

   //Gedchtnis benutzen !!  : Position merken
   AkuelleXPos := pXPos;
   AkuelleYPos := pYPos;

   //neu Zeichnen an neuer Position
   meinStift.normal;
   meinStift.bewegeBis(AkuelleXPos,AkuelleYPos);
   meinStift.zeichneKreis(10);
end;

//-------- gibFrei (public) --------------------------------------------
destructor TKugel.gibFrei;
begin
  meinStift.gibFrei;
end;

end.
